#if !defined( _LIGHTING_GLOBALS_FXH )
#define _LIGHTING_GLOBALS_HLSL

#include "ambient_lighting_globals.fxh"
#include "direct_lighting_globals.fxh"


//---------------------------------------------------------------------------------
//
// HLSL header file contains macros and definitions for specialisable lighting.
//

#define DECLARE_LIGHTING_PARAMS		\
	DECLARE_AMBIENT_LIGHTING_PARAMS	\
	DECLARE_DIRECT_LIGHTING_PARAMS

// this version kept for backwards compatibility
#define DECLARE_LIGHTING_INTERPOLATORS( __index__ )	\
	DECLARE_AMBIENT_LIGHTING_INTERPOLATORS_VS( __index__ )	\
	DECLARE_DIRECT_LIGHTING_INTERPOLATORS( __index__ )

#define DECLARE_LIGHTING_INTERPOLATORS_VS( __index__ )	\
	DECLARE_AMBIENT_LIGHTING_INTERPOLATORS_VS( __index__ )	\
	DECLARE_DIRECT_LIGHTING_INTERPOLATORS( __index__ )

#define DECLARE_LIGHTING_INTERPOLATORS_PS( __index__ )	\
	DECLARE_AMBIENT_LIGHTING_INTERPOLATORS_PS( __index__ )	\
	DECLARE_DIRECT_LIGHTING_INTERPOLATORS( __index__ )

#define DO_VS_LIGHTING_CALCULATIONS		\
	DO_VS_AMBIENT_LIGHTING_CALCULATIONS_TRANSITION	\
	DO_VS_DIRECT_LIGHTING_CALCULATIONS
	
#ifndef _3DSMAX_
#define	ENABLE_FOG	// leaving fog on permanently
#endif

#ifdef ENABLE_FOG

	// fog global variables
	SHARE_PARAM float3	fog_colour : FogColour			// RGB colour of fog
	<
		bool appEdit = false;
	>;
	SHARE_PARAM float2	fog_dist_max : FogDistMax		// distance of fog + max amount of fogging
	<
		bool appEdit = false;
	>;
	
	// apply fog using fogAmount (0.0 - 1.0), from max strength to full
	#define	APPLY_FAR_DISTANCE_FOG( __accumulator__, fogAmount )	\
		__accumulator__.rgb = lerp( __accumulator__.rgb, fog_colour.rgb, lerp( fog_dist_max.y, 1.0f, fogAmount ) );

	// apply fog using fogAmount (0.0 - 1.0), up to a maximum strength
	#define	APPLY_DISTANCE_FOG( __accumulator__, fogAmount )	\
		__accumulator__.rgb = lerp( __accumulator__.rgb, fog_colour.rgb, fogAmount*fog_dist_max.y );

	// apply fog using the pixel distance
	#define	NEED_WORLDPOS
	#define	DO_PS_DISTANCE_FOG( __accumulator__, __eye__ )	\
		{\
			float distSquared = dot( __eye__, __eye__ );	\
			float fog_amount = saturate( distSquared / ( fog_dist_max.x*fog_dist_max.x ) );	\
			APPLY_DISTANCE_FOG( __accumulator__, fog_amount );\
		}
		
#else

	#define	APPLY_FAR_DISTANCE_FOG( __accumulator__, fogAmount )
	#define	APPLY_DISTANCE_FOG( __accumulator__, fogAmount )
	#define	DO_PS_DISTANCE_FOG( __accumulator__, __eye__  )
	
#endif


#if !defined( _DEBUG_VISUALISATION_ )

// Normal lighting calcs

#define DO_PS_LIGHTING_CALCULATIONS( __accumulator__, __eye__ )		\
	DO_PS_AMBIENT_LIGHTING_CALCULATIONS( __accumulator__ )	\
	DO_PS_DIRECT_LIGHTING_CALCULATIONS( __accumulator__, __eye__ )	\
	DO_PS_DISTANCE_FOG( __accumulator__, __eye__  )

#else
// Visualisation mode lighting calcs

#define DO_PS_LIGHTING_CALCULATIONS( __accumulator__, __eye__ )		\
	DO_PS_AMBIENT_LIGHTING_CALCULATIONS( __accumulator__ )	\
	DO_PS_DIRECT_LIGHTING_CALCULATIONS( __accumulator__, __eye__ )	\
	DO_PS_DISTANCE_FOG( __accumulator__, __eye__  )	\
	__accumulator__ = lerp( __accumulator__, _input.colour, 0.5f );

#endif


//---------------------------------------------------------------------------------
//
// Vertex Lighting Versions (no shadowing)
//

#define DO_VERTEX_LIGHTING( __worldPos__, __worldNormal__, __accumulator__ )									\
	DO_VS_AMBIENT_LIGHTING_CALCULATIONS																			\
	DO_VERTEXLIGHTING_DIRECT_LIGHTING_CALCULATIONS( __worldPos__, __worldNormal__, __accumulator__ )


//---------------------------------------------------------------------------------
//
// Macro used for regenerating the worldPos variable within pixel shaders
//

	#if defined(_3DSMAX_)
		#define PS_GENERATE_WORLDPOS( _eye_ ) \
			float3 worldPos	=	viewI[ 3 ] - _eye_;
	#elif !defined(NEED_WORLDPOS)
		#define PS_GENERATE_WORLDPOS( _eye_ )
	#else
		#define	PS_GENERATE_WORLDPOS( _eye_ ) \
			float3 worldPos	=	worldCameraPos - _eye_;
	#endif

#endif	//  _LIGHTING_GLOBALS_FXH
